You can create your own templates for triggers, procedures, etc
by simply creating a .tpl file in the Template directory.

A .tpl file is a plain text file with variables that can be entered
when creating a new program unit.

A variable is enclosed in square brackets. A simple temlate could look
like this:

  create procedure [Procedure name]
  begin

  end;

When this template is opened. you are prompted for a "Function name" and the
entered value replaces the part between brackets.

You can also define a default value like this:

  create procedure [With default = MyProcedure]
  begin

  end [With default = Ignored default];

Note that the variable is defined twice but you will only be prompted once.
Both will be replaced by the same value. The first occurence of a variable 
determines the default value.

To give the cursor a fixed starting point add a # as variable.

  create procedure [With default = Also ignored default]
  begin
    [#]
  end [With default];

Spaces before and after the variable name, the equal sign and the default value
have no influence. Variables are not case sensitive.

If you want to select a value from a list, you can do this:

  Type = [Type = varchar2, Integer, bool, float]

This will be presented as a dropdown list where you can select one of the
four defined values, the first one is the default.

If you want to present a list but still be able to enter your own values,
add a ... to the list like this:

  Type = [Any type = varchar2, Integer, bool, float, ...]

This will give a dropdown list where you can enter any text but you can select
from the set of defined values.

You can also bring up a checkbox by seperating two values by a slash. The text
before the slash is inserted by default (unchecked), the second part is inserted
when checked.

  Select * from <table> [Ordered = / Order by name ]

For templates with two parts like the body and specification of a package you
can add a / on an empty line like this:
/
This will be the first line on the second page

You can also take a look at the trigger.tpl file for more information
